<!-- Page header -->
{capture name="buttons"}
	<button class="btn btn-sm btn-primary" data-bs-toggle="collapse" data-bs-target="#add_logo">
		<i class="ph-image me-2"></i>
        {if !empty($logos->logoUrl)}{logo:change}{else}{logo:add}{/if}
	</button>
{/capture}

{capture name="breadcrumb"}
	<a href="{$adminUrl}/logo" class="breadcrumb-item">{$title}</a>
{/capture}

{capture name="showBy"}
{/capture}

{include file="components/page-header.tpl" buttons=$smarty.capture.buttons breadcrumb=$smarty.capture.breadcrumb showBy=$smarty.capture.showBy}
<!-- /page header -->

<div class="content">

	<div id="add_logo" class="collapse">
		<div class="card border shadow-sm">
			<div class="card-header d-flex flex-wrap">
				<h6 class="mb-0">{logo:add}</h6>
				<div class="d-inline-flex ms-auto">
					<a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
				</div>
			</div>
			<div class="collapse show">
				<div class="card-body">
					<div id="upload_files" class="dropzone dropzone-product">
						<div class="dz-default dz-message"></div>
					</div>
				</div>
			</div>
		</div>
	</div>

	<div class="card border shadow-sm">
		<div class="table-responsive">
			<table class="table table-togglable table-striped table-hover" id="logos">
				<thead>
				<tr>
					<th data-hide="ID" class="text-center" width="30">{logo:title}</th>
					<th data-hide="image" class="text-center" nowrap="nowrap">{logo:logoFile}</th>
					<th data-hide="image">{logo:logoUrl}</th>
					<th data-hide="image" class="text-center" nowrap="nowrap">{logo:logoExt}</th>
					<th class="text-center text-muted" width="30"><i class="ph-check"></i></th>
				</tr>
				</thead>
                {if !empty($logos.fileName)}
					<tbody>
					<tr id="logo-1">
						<td><img id="preview" src="{$UPLOAD_URL}/{$logos.fileName}" style="max-width: 200px;max-height: 100px;"></td>
						<td class="text-center">{$logos.logoName}</td>
						<td class="text-start text-nowrap">{$UPLOAD_URL}/{$logos.fileName}</td>
						<td class="text-center">{$logos.logoType}</td>
						<td class="text-center">
							<div class="d-inline-flex">
								<button class="dropdown-item btn btn-link text-danger" onclick="deleteLogo('{$logos.fileName|escape}', '{$logos.logoName|escape}');" data-bs-popup="tooltip" title="{general:delete}" data-bs-placement="auto"><i class="ph-trash"></i></button>
							</div>
						</td>
					</tr>
					</tbody>
                {else}
					<tbody><tr><td class="text-center" colspan="5">- {general:none} -</td></tr></tbody>
                {/if}
			</table>
		</div>
	</div>

</div>


<script>

    var logoLang = "{foreach item=language from=$LANGUAGES}{if ($SITE_LANG eq $language.codename) || (!$SITE_LANG && $language.isDefault)}{$language.codename}{/if}{/foreach}";
    Dropzone.autoDiscover = false;

    $("#upload_files").dropzone({
        paramName: "file",
        url: "{$adminUrl}/logo?action=upload",
        addRemoveLinks: true,
        dictRemoveFile: 'Скрыть',
        maxFilesize: 2,
        maxFiles: 1,
        acceptedFiles: "image/*",
        init: function() {
            this.on("success", function(file, response) {
                console.log(response);
                new Noty({ text: response.message, type: response.type }).show();
                setTimeout(function() {
                    location.reload()
                },2500);
            });
            this.on('error', function (file, response){
                file.previewElement.classList.add("dz-error");
                new Noty({ text: response.message, type: 'error' }).show();
            });

        }
    });

    function deleteLogo(urlFile, name) {
        bootbox.confirm({
            closeButton: false,
            message: lang['sureToDelete'] + ' "'+name+'"?',
            callback: function(res) {
                if (res === true) {
                    $.post("index.php?mod=logo&action=remove&logo[fileName]=" + urlFile, function(response){
	                    console.log(response);
	                    if (response.status == 200) {
	                        const el = document.getElementById("logo-1");
	                        el.parentNode.removeChild(el);
	                    }
                        new Noty({ text: response.message, type: response.type }).show();
                    }, 'json');
                }
            }
        })
    }

</script>





