<?php

namespace Mnv\Core;

use PhpOffice\PhpSpreadsheet\IOFactory;

/**
 * Class ImportService
 * @package Mnv\Core
 */
class ImportService
{

//    protected int $projectId = 0;

    public function importExcel(string $inputFileName, $sectionId, $managerId): bool
    {
        $spreadsheet = IOFactory::load($inputFileName);
        $sheetData = $spreadsheet->getActiveSheet()->toArray();

//print_r($sheetData);

        if (!empty($sheetData)) {
            if (!empty($sectionId)) {
                if ($this->hasTable($sectionId)) {
                    for ($i = 1; $i < count($sheetData); $i++) {
                        if (!empty($sheetData[$i])) {
//                            print_r($sheetData[$i]);
                            /** проект */
                            if ($sectionId == 118) {
                                $this->addTableSecondaryTrades($sheetData[$i], $sectionId, $managerId);
                            } else {
                                $this->addTable($sheetData[$i], $sectionId, $managerId);
                            }
                        }
                    }
                }
            }

            return true;
        }

        return false;
    }

    private function hasTable($sectionId): bool
    {
       $result = connect('tables')->where('sectionId', $sectionId)->get();
       if (!empty($result)) {
           if (connect('tables')->where('sectionId', $sectionId)->delete()) {
               return true;
           }

           return false;
       }

        return true;
    }

// TODO: сделать insert -> projects и получить projectId
    protected function addTable($data, $sectionId, $managerId)
    {
//        if (!empty($data[0])) {
//            $date = explode('/', $data[0]);
//            $newDate = $date[2] . '-' . $date[1] . '-' . $date[0] . '00:00:00';
//        }
        $project = array_filter([
            'date'          => !empty($data[0]) ? adjustTime(date('Y-m-d', strtotime($data[0])),  false) : date('Y-m-d', strtotime('01/01/1970')),
            'sectionId'     => $sectionId,
            'columnA'       => $data[1],
            'columnB'       => $data[2] ?? null,
            'columnC'       => $data[3] ?? null,
            'columnD'       => $data[4] ?? null,
            'columnE'       => $data[5] ?? null,
            'columnF'       => $data[6] ?? null,
            'columnG'       => $data[7] ?? null,
            'columnH'       => $data[8] ?? null,

            'modifiedBy'    => $managerId,
            'modifiedOn'    => gmdate('Y-m-d H:i:s'),
            'addedBy'       => $managerId,
            'addedOn'       => gmdate('Y-m-d H:i:s'),
        ]);

      connect('tables')->insert($project);
    }

    // TODO: сделать insert -> projects и получить projectId
    protected function addTableSecondaryTrades($data, $sectionId, $managerId)
    {

        $project = array_filter([
            'date'          => !empty($data[0]) ? adjustTime(date('Y-m-d', strtotime($data[0])),  false) : date('Y-m-d', strtotime('01/01/1970')),
            'maturityDate'  => !empty($data[2]) ? adjustTime(date('Y-m-d', strtotime($data[2])),  false) : date('Y-m-d', strtotime('01/01/1970')),
            'sectionId'     => $sectionId,
            'columnA'       => $data[1],
            'columnC'       => $data[3] ?? null,
            'columnD'       => $data[4] ?? null,
            'columnE'       => $data[5] ?? null,
            'columnF'       => $data[6] ?? null,
            'columnG'       => $data[7] ?? null,
            'columnH'       => $data[8] ?? null,

            'modifiedBy'    => $managerId,
            'modifiedOn'    => gmdate('Y-m-d H:i:s'),
            'addedBy'       => $managerId,
            'addedOn'       => gmdate('Y-m-d H:i:s'),
        ]);

        connect('tables')->insert($project);
    }







}