<?php


namespace Mnv\Modules;

use Mnv\Core\Locale\I18N;

/**
 * Class Echarts
 * @package Mnv\Modules
 */
class Echarts
{
    public $response = [];

    public $sectionId;


    public function __construct($sectionId)
    {

        $section = connect('sections')->select('sectionId, name')->where('sectionId', $sectionId)->get('array');

        $this->response['id'] = $section['sectionId'];
        $this->response['name'] = $section['name'];

    }

    public function stats($sectionId, $colors)
    {

//        $this->response['name_data'] = array(
//            I18N::locale("Объём эмиссии (млрд. сум)", "Объём эмиссии (млрд. сум)", "Объём эмиссии (млрд. сум)"),
//            I18N::locale("Объём размещения (млрд. сум)", "Объём размещения (млрд. сум)", "Объём размещения (млрд. сум)"),
//            I18N::locale("Средневз. доходность", "Средневз. доходность", "Средневз. доходность"),
//        );
        $categories['id'] = $this->response['id'];
        $categories['name'] = $this->response['name'];
//        $categories['data']['color'] = $colors;

        $categories['data']['y_data']['color']          = $colors[0];
        $categories['data']['y_data']['name']           = I18N::locale("Объём эмиссии (млрд. сум)", "Чиқарилиш ҳажми (млрд. сўм)", "Volume of issue (billion UZS)", "Chiqarilish hajmi (mlrd. so'm)");
        $categories['data']['y_data_second']['color']   = $colors[1];
        $categories['data']['y_data_second']['name']    = I18N::locale("Объём размещения (млрд. сум)", "Жойлаштириш ҳажми (млрд. сўм)", "Volume of placement (billion UZS)", "Joylashtirish hajmi (mlrd. so'm)");
        $categories['data']['line_data']['color']       = $colors[2];
        $categories['data']['line_data']['name']        = I18N::locale("Средневз. доходность", "Ўрт. тортилг. даромадлилик", "Weight. aver. yield", "O'rt. tortilg. daromadlilik");


                if ($sectionId > 0) connect()->where('sectionId', $sectionId);

        $echarts = connect('tables')->select('*')->where('status', 'V')->orderBy('date DESC')->limit(40)->getAll('array');
        $collection = collect($echarts);
        $echarts = $collection->sortBy('date', SORT_NATURAL)->values()->all();

        foreach ($echarts as $echart) {
            $categories['data']['x_data']['data'][]         = adjustTime($echart['date'], false, 'd.m.Y');
            $categories['data']['y_data']['data'][]         = (float)str_replace(",", ".", $echart['columnB']);
            $categories['data']['y_data_second']['data'][]  = (float)str_replace(",", ".", $echart['columnC']);
            $categories['data']['line_data']['data'][]      = (float)str_replace(",", ".", $echart['columnD']);
        }
        $this->response['categoryes'][] = $categories;

        return $this->response;
    }

    /** Облигации ЦБ */
    public function statsCBB($sectionId, $colors): array
    {

//        $this->response['name_data'] = array(
//            I18N::locale("Объём эмиссии (млрд. сум)", "Объём эмиссии (млрд. сум)", "Объём эмиссии (млрд. сум)"),
//            I18N::locale("Объём торгов (млрд. сум)", "Объём размещения (млрд. сум)", "Объём размещения (млрд. сум)"),
//            I18N::locale("Средневз. доходность", "Средневз. доходность", "Средневз. доходность"),
//        );
        $categories['id'] = $this->response['id'];
        $categories['name'] = $this->response['name'];
//        $categories['data']['color'] = $colors;

        $categories['data']['y_data']['color'] = $colors[0];
        $categories['data']['y_data']['name'] = I18N::locale("Объём эмиссии (млрд. сум)", "Чиқарилиш ҳажми (млрд. сўм)", "Volume of issue (billion UZS)", "Chiqarilish hajmi (mlrd. so'm)");
        $categories['data']['y_data_second']['color'] = $colors[1];
        $categories['data']['y_data_second']['name'] = I18N::locale("Объём торгов (млрд. сум)", "Савдолар ҳажми (млрд. сўм)", "Trading volume (billion UZS)", "Savdolar hajmi (mlrd. so'm)");
        $categories['data']['line_data']['color'] = $colors[2];
        $categories['data']['line_data']['name'] = I18N::locale("Средневз. доходность", "Ўрт. тортилг. даромадлилик", "Weight. aver. yield", "O'rt. tortilg. daromadlilik");


        if ($sectionId > 0) connect()->where('sectionId', $sectionId);

        $echarts = connect('tables')->select('*')->where('status', 'V')->orderBy('date DESC')->groupBy('date')->limit(20)->getAll('array');
        $collection = collect($echarts);
        $echarts = $collection->sortBy('date', SORT_NATURAL)->values()->all();
        foreach ($echarts as $echart) {
            $categories['data']['x_data']['data'][]         = adjustTime($echart['date'], false, 'd.m.Y');
            $categories['data']['y_data']['data'][]         = (float)str_replace(",", ".", $echart['columnC']);
            $categories['data']['y_data_second']['data'][]  = (float)str_replace(",", ".",$echart['columnE']);
            $categories['data']['line_data']['data'][]      = (float)str_replace(",", ".", $echart['columnF']);
        }
        $this->response['categoryes'][] = $categories;

        return $this->response;
    }


    /** Вторичные торги */
    public function statsST($sectionId, $colors): array
    {

//        $this->response['name_data'] = array(
//            I18N::locale("Объём сделок (млрд.сум)", "Объём сделок (млрд.сум)", "Объём сделок (млрд.сум)"),
//            I18N::locale("Цена сделок в % к номиналу", "Объём сделок (млрд.сум)", "Объём сделок (млрд.сум)")
//        );

        $categories['id'] = $this->response['id'];
        $categories['name'] = $this->response['name'];
//        $categories['data']['color'] = $colors;

        $categories['data']['y_data']['color'] = $colors[0];
        $categories['data']['y_data']['name'] = I18N::locale("Объём сделок (млрд.сум)", "Битимлар ҳажми (млрд. сўм)", "Volume of transactions (billion UZS)", "Bitimlar hajmi (mlrd. so'm)");
        $categories['data']['line_data']['color'] = $colors[1];
        $categories['data']['line_data']['name'] = I18N::locale("Цена сделок в % к номиналу", "Номинал қийматга нисбатан битимлар нархи, %да", "Deal price in % to face value", "Nominal qiymatga nisbatan bitimlar narxi, %da");

        if ($sectionId > 0)
            connect()->where('sectionId', $sectionId);

        $echarts = connect('tables')->select('*')->where('status', 'V')->orderBy('date DESC')->limit(20)->getAll('array');
        $collection = collect($echarts);
        $echarts = $collection->sortBy('date', SORT_NATURAL)->values()->all();
        foreach ($echarts as $echart) {
            $categories['data']['x_data']['data'][]     = adjustTime($echart['date'], false, 'd.m.Y');
            $categories['data']['y_data']['data'][]     = (float)str_replace(",", ".",$echart['columnE']);
            $categories['data']['line_data']['data'][]  = (float)str_replace(",", ".", $echart['columnH']);
        }
        $this->response['categoryes'][] = $categories;

//        print_r($this->response);

        return $this->response;
    }

    /** Вторичные торги */
    public function statsCBDA($sectionId, $colors): array
    {

        $categories['id'] = $this->response['id'];
        $categories['name'] = $this->response['name'];

        $categories['data']['y_data']['color'] = $colors[0];
        $categories['data']['y_data']['name'] = I18N::locale("Объём сделок (млрд.сум)", "Битимлар ҳажми (млрд. сўм)", "Volume of transactions (billion UZS)", "Bitimlar hajmi (mlrd. so'm)");
        $categories['data']['line_data']['color'] = $colors[1];
        $categories['data']['line_data']['name'] = I18N::locale("Цена сделок в % к номиналу", "Номинал қийматга нисбатан битимлар нархи, %да", "Deal price in % to face value", "Nominal qiymatga nisbatan bitimlar narxi, %da");

        if ($sectionId > 0)
            connect()->where('sectionId', $sectionId);

        $echarts = connect('tables')->select('*')->where('status', 'V')->orderBy('date DESC')->limit(20)->getAll('array');
        $collection = collect($echarts);
        $echarts = $collection->sortBy('date', SORT_NATURAL)->values()->all();

        foreach ($echarts as $echart) {
            $categories['data']['x_data']['data'][]     = adjustTime($echart['date'], false, 'd.m.Y');
            $categories['data']['y_data']['data'][]     = (float)str_replace(",", ".",$echart['columnC']);
            $categories['data']['line_data']['data'][]  = (float)str_replace(",", ".", $echart['columnE']);
        }
        $this->response['categoryes'][] = $categories;

//        print_r($this->response);

        return $this->response;
    }


}