<?php


namespace Mnv\Modules;


use Mnv\Core\Config;
use Mnv\Core\DB;
use Mnv\Core\Locale\I18N;
use Mnv\Core\Uploads\ImageSizes;

class Jobs
{

    /** @var string */
    private string $table = 'jobs';

    /** @var string  */
    private string $table_description = 'jobs_description';

//    private string $columns = 'j.jobId, j.sectionId AS nomination, j.url, s.name, j.fileName, jd.lang_code, jd.title, jd.alias, jd.telegram, jd.link, jd.links, jd.content';
//    private string $columns = 'jd.lang_code, j.sectionId AS nomination_id, s.name AS nomination, j.jobId AS job_id, j.url AS job_url,  jd.title, jd.alias, jd.telegram, jd.link, jd.links, jd.project, jd.content';
//    private string $columns = 'jd.lang_code, j.sectionId AS nomination_id, j.status, j.jobId AS job_id, j.url AS job_url, jd.title, jd.telegram, jd.link, jd.links, jd.project, jd.content';
//    private string $columns = 'jd.lang_code, j.sectionId AS nomination_id, j.jobId AS job_id, j.url AS job_url, jd.title, jd.telegram, jd.link, jd.links, jd.project, jd.content, ji.fileId, j.addedOn';
    private string $columns = 'jd.lang_code, j.sectionId AS nomination_id, j.jobId AS job_id, j.url AS job_url, jd.title, jd.telegram, jd.link, jd.links, jd.project, jd.content, 
    j.addedOn, ji.fileId, f.directory, f.path, f.fileName, f.size, f.mime_type';

    /** @var string  */
    private string $table_image = 'job_images';

    /** @var string  */
    private string $primaryKey = 'jobId';

    /** @var string  */
    private string $orderBy = 'j.addedOn ASC';

    /** @var array */
    public $response = [];

    /** @var array */
    public $data = [];

    /** @var array */
    public $description = [];

    /** @var int */
    public $id;

    private $config =  [
        'key'      => '64c0d0fec708e50621ebd314',
        'login'    => 'lifestyle',
    ];

    public $request;
    public $brandId;
    public $nominationId;

    private $nominations = [];

    public function __construct()
    {
        $request_body  = file_get_contents('php://input');
        $this->request = json_decode($request_body, true);

        $this->getNomination();
    }

    /** @throws \Exception */
    public function run()
    {
        $headers = getallheaders();

        try {
            if (!$headers || !isset($headers['Authorization'])) {
                throw new \Exception('Not Authorization');
            }

            preg_match('/Bearer\s(\S+)/', $headers['Authorization'], $matches);
            if (!isset($matches[1])) {
                throw new \Exception('No Bearer Token');
            }

            if (base64_decode($matches[1]) != $this->config['login'] . ":" . $this->config['key']) {
                throw new \Exception('Invalid token.');
            }


            $this->allNominations();
        } catch (\Exception $e) {
            $this->response = array('status' => 400, 'error' => $e->getMessage(), 'message' => null, 'data' => null);
        }

    }

    public function getToken()
    {
        $token = base64_encode($this->config['login'] . ":" . $this->config['key']);
        $this->response = array('status' => 200, 'error' => null,  'message' => 'Generation token', 'token' => $token);
    }


    public function prepare(array $data, array $languages, $fileId, $pdfs)
    {
        global $SECTIONS, $userAuth;

        $data['userId']         = $userAuth->id();
        $data['addedBy']        = $userAuth->id();
        $data['sectionId']      = $data['nomination'];
        $data['addedOn']        = gmdate('Y-m-d H:i:s');
        $data['orderBy']        = $this->getMaxValue('orderBy') + 1;
        $data['fileName']       = $this->getMaxId();
        $data['modifiedOn']     = gmdate('Y-m-d H:i:s');
        $data['publishedOn']    = gmdate('Y-m-d H:i:s');
        $data['consumer']       = (isset($data['consumer']) &&  $data['consumer'] == 'on') ? 1 : 0;
        $data['expert']         = (isset($data['expert']) && $data['expert'] == 'on') ? 1 : 0;
        $data['payment']        = 0;

        $data['url'] = $SECTIONS[$data['sectionId']]['path'] . '/' . $data['fileName'] . '.' . Config::getValue('file_extension');

        unset($data['nomination']);
//print_r($data);
        if ($this->id = $this->insert($data)) {

            foreach ($languages as $language) {
                $this->insetDescription($language['codename']);
            }
            if (!empty($fileId) && $fileId > 0) {
                $this->addingPictureToJob($fileId);
            }

            if (!empty($pdfs)) {
                $this->addingPdf($pdfs);
            }

            return true;
        }

        return false;
    }

    /** Добавление работы */
    private function insert(array $data)
    {
        return connect($this->table)->insert($data);
    }

    /** Добавление описания к работе */
    private function insetDescription($language): void
    {
        $description                = $this->description[$language];
        $description['lang_code']   = $language;
        $description['jobId']       = $this->id;

        connect($this->table_description)->insert($description);
    }


    /** Получить ID последней работы + 1 */
    private function getMaxId()
    {
        $ID = $this->getMaxValue('jobId');
        return !empty($ID) ? $ID + 1 : 1;
    }
    private function getMaxValue(string $field, ?string $name = null)
    {
        return connect($this->table)->max($field, $name)->getValue();
    }


    /**
     * Добавление картинки
     *
     * @param array $fileId
     * @return bool
     */
    public function addingPictureToJob($fileId): bool
    {
        $imageUpload = [
            $this->primaryKey   => $this->id,
            'fileId'            => $fileId,
            'type'              => 'general',
            'position'          => 'default',
            'orderBy'           => 0
        ];

        if (connect($this->table_image)->insert($imageUpload)) {
            return true;
        }

        return false;
    }

    /**
     * Добавление картинки
     *
     * @param array $pdfs
     */
    public function addingPdf($pdfs): void
    {
        foreach ($pdfs as $pdf) {
            connect($this->table_image)->insert([
                $this->primaryKey   => $this->id,
                'lang_code'         => $pdf['lang_code'],
                'fileId'            => $pdf['fileId'],
                'type'              => 'docs',
                'position'          => 'default',
                'orderBy'           => 0
            ]);
        }
    }

    /** Дублировать в другую номинацию */
    public function copy($userId)
    {
        global $SECTIONS, $smarty;

        //
        $error_message = I18N::locale(
            "В этой номинации ваш бренд уже существует.",
            "Ushbu nominatsiyada sizning brendingiz allaqachon mavjud.",
            "Your brand already exists in this category."
        );

        $success_message = I18N::locale(
            "Ваш бренд успешно продублирован и отправлен на модерацию.",
            "Sizning brendingiz muvaffaqiyatli takrorlandi va moderatsiyaga yuborildi.",
            "Your brand has been successfully duplicated and submitted for moderation."
        );

        /** Получение бренда `$this->brandId` у пользователя `$userId` */
        $nominee = connect($this->table)->select('sectionId, status, brand, inn, fullName, phone, email, consumer, expert')->where($this->primaryKey, $this->brandId)->where('userId', $userId)->get('array');
        if ($nominee['sectionId'] == $this->nominationId) {
            return array('status' => 400, 'message' => $error_message, 'error' => 'Error', 'type' => 'error');
        }

        /** Проверка на существование бренда в данной номинации `$this->nominationId` и `$nominee['brand']` */
        if (connect($this->table)->select('sectionId')->where('LOWER(brand)', strtolower($nominee['brand']))->where('sectionId', $this->nominationId)->where('userId', $userId)->getAll('array')) {
            return array('status' => 400, 'message' => $error_message, 'error' => 'Error', 'type' => 'error');
        }
//        print_r(connect()->getQuery());

        $nominee['sectionId']      = $this->nominationId;
        $nominee['userId']         = $userId;
        $nominee['addedBy']        = $userId;
        $nominee['addedOn']        = gmdate('Y-m-d H:i:s');
        $nominee['orderBy']        = $this->getMaxValue('orderBy') + 1;
        $nominee['fileName']       = $this->getMaxId();
        $nominee['modifiedOn']     = gmdate('Y-m-d H:i:s');
        $nominee['publishedOn']    = gmdate('Y-m-d H:i:s');
        $nominee['status']         = 'H';
        $nominee['payment']        = 0;
        $nominee['url'] = $SECTIONS[$nominee['sectionId']]['path'] . '/' . $nominee['fileName'] . '.' . Config::getValue('file_extension');

        /** Вставка в другую номинацию  */
        $jobId = $this->insert($nominee);
        if (!empty($jobId)) {

            /** Получение описание бренда `$this->brandId` */
            $descriptions = connect($this->table_description)->where($this->primaryKey, $this->brandId)->indexKey('lang_code')->getAllIndexes('array');
            foreach ($descriptions as $description) {
                $description['jobId'] = $jobId;
                /** Вставка описание для номинации  */
                connect($this->table_description)->insert($description);
            }

            /** Получение логотипа(основная картинка) бренда `$this->brandId` */
            $logo = connect($this->table_image)->select('fileId, type, position')->where($this->primaryKey, $this->brandId)->where('type', 'general')->get('array');
            if (!empty($logo)) {
                $logo['jobId'] = $jobId;
                /** Вставка логотипа(основная картинка) для номинации  */
                connect($this->table_image)->insert($logo);
            }

            /** Получение файлов(PDF) бренда `$this->brandId` */
            $images = connect($this->table_image)->select('lang_code, fileId, type, position')->where($this->primaryKey, $this->brandId)->where('type', 'docs')->indexKey('lang_code')->getAllIndexes('array');
            if (!empty($images)) {
                foreach ($images as $image) {
                    $image['jobId'] = $jobId;
                    /** Вставка файлов(PDF) для номинации  */
                    connect($this->table_image)->insert($image);
                }
            }
        }

        /** Получение нового добавленного */
        if ($newNominee = connect($this->table)->select('jobId, brand, publishedOn, status, payment')->where($this->primaryKey, $jobId)->where('userId', $userId)->get('array')) {
            $smarty->assign('nominee', $newNominee);
            $result = $smarty->fetch('items/item-nominee.tpl');
            // Ваша работа успешно отправлена на модерацию.
            return array('status' =>200, 'message' => $success_message, 'error' => null, 'data' => $result, 'type' => 'success');
        }


    }



    private function getNomination(): void
    {
        global $LANGUAGES;

        $nominations = [];
        foreach ($LANGUAGES as $LANGUAGE) {
            $table = ($LANGUAGE['codename'] == 'uz') ? 'ls_'. $LANGUAGE['codename'] . '_sections' : 'ls_sections';
            $nominations[$LANGUAGE['codename']] = DB::init()->connect()->query("SELECT `sectionId`, `name`, `status`, `sortOrder` FROM " .$table ." WHERE parentId=4 AND status='V' ORDER BY sortOrder ASC")->cache(60)->fetchAll('array');
        }

        $this->nominations = [];
        collect($nominations)->map(function ($section, $index) {
            collect($section)->map(function ($item) use ($index) {
                $this->nominations[$item['sectionId']][$index . '_job_category']               = $item['sectionId'];
                $this->nominations[$item['sectionId']][$index . '_job_nomination']             = $item['name'];
                $this->nominations[$item['sectionId']][$index . '_job_nomination_status']      = $item['status'] == 'V';
                $this->nominations[$item['sectionId']][$index . '_job_nomination_order_by']    = $item['sortOrder'];
            })->all();
        })->all();
    }

//    private function getNomination(): void
//    {
//        $this->nominations = connect('sections')->select('sectionId, name, status, sortOrder')->where('parentId', 4)
//            ->where('status', 'V')->orderBy('sortOrder ASC')->cache(60)->getAll('array');
//    }

    /**
     * Новый вид
     * 1 Номинации
     * 2 Потом получение работы
     * 3 формирование работ и возврат
     */
    public function allNominations(): void
    {
        $nominations = collect($this->nominations)->map(function ($nomination, $nominationId) {
            $participants = $this->getParticipants($nominationId);

            $collection = [];
            collect($participants)->map(function ($item) use ($nomination, &$collection) {
                $prefix = ($item['lang_code'] == 'uz') ? '/' . $item['lang_code'] : '';
                $id = $item['job_id'];
                if (isset($collection[$id])) {
                    $collection[$id][$item['lang_code'] . '_job_id']        = $item['job_id'];
                    $collection[$id][$item['lang_code'] . '_job_category']  = $item['nomination_id'];
                    $collection[$id][$item['lang_code'] . '_job_image']     = $this->getImageUrl($item);
                }
                $collection[$id][$item['lang_code'] . '_job_id']        = $item['job_id'];
                $collection[$id][$item['lang_code'] . '_job_category']  = $item['nomination_id'];
                $collection[$id][$item['lang_code'] . '_job_image']     = $this->getImageUrl($item);
                $collection[$id][$item['lang_code'] . '_job_url']       = GLOBAL_URL . $prefix . $item['job_url'];

                $collection[$id][$item['lang_code'] . '_job_nomination']            = $nomination[$item['lang_code'] . '_job_nomination'];
                $collection[$id][$item['lang_code'] . '_job_nomination_status']     = $nomination[$item['lang_code'] . '_job_nomination_status'] == 'V';
                $collection[$id][$item['lang_code'] . '_job_nomination_order_by']   = $nomination[$item['lang_code'] . '_job_nomination_order_by'];
                $collection[$id][$item['lang_code'] . '_job_name']          = $item['title'];
                $collection[$id][$item['lang_code'] . '_job_link']          = $item['link'];
                $collection[$id][$item['lang_code'] . '_job_description']   = $item['content'];
                $collection[$id][$item['lang_code'] . '_job_added']         = $item['addedOn'];
            })->all();

            return $collection;
        })->flatten(1)->all();


        $this->response = array('status' =>200, 'message' => "Request completed successfully", 'error' => null, 'data' => $nominations);
    }


    private function getParticipants($sectionId)
    {
        $participants = connect($this->table . ' AS j')
            ->usingJoin($this->table_description . ' AS jd', $this->primaryKey)
            ->leftJoin($this->table_image . ' AS ji', 'ji.jobId', '=', 'j.jobId')
            ->leftJoin('files AS f', 'f.fileId', '=', 'ji.fileId')
            ->select($this->columns)
            ->where('j.sectionId', $sectionId)
            ->where('j.status', 'V')->orderBy($this->orderBy)
//            ->cache(60)
            ->getAll('array');
//        print_r(connect()->getQuery().PHP_EOL);
        return $participants;
    }

    /**
     * @param $fileId
     * @return string|null
     * directory
     * path
     * fileName
     * size
     * mime_type
     */
    private function getImageUrl($file): ?string
    {
        if ($file) {
            return SITE_URL . ImageSizes::init()->get(null, $file)['original'];
        }
        return null;
    }




//    public function all(): void
//    {
//        $jobs = connect($this->table . ' AS j')
//            ->usingJoin($this->table_description . ' AS jd', $this->primaryKey)
//            ->select($this->columns)
//            ->where('j.status', 'V')
//            ->orderBy($this->orderBy)
////            ->cache(60)
//            ->getAll('array');
////        print_r(connect()->getQuery().PHP_EOL);
//
////        print_r($jobs);
//        $collection = [];
//        collect($jobs)->map(function ($item) use (&$collection) {
//            $prefix = ($item['lang_code'] == 'uz') ? '/' . $item['lang_code'] : '';
//            $id = $item['job_id'];
//            $section = $this->getNominationName($item['lang_code'], $item['nomination_id']);
//            if (!empty($section)) {
//                if (isset($collection[$id])) {
//                    $collection[$id][$item['lang_code'] . '_job_id'] = $item['job_id'];
//                    $collection[$id][$item['lang_code'] . '_job_category'] = $item['nomination_id'];
//                    $collection[$id][$item['lang_code'] . '_job_image'] = $this->image($item['job_id']);
//                }
//                $collection[$id][$item['lang_code'] . '_job_id']        = $item['job_id'];
//                $collection[$id][$item['lang_code'] . '_job_category']  = $item['nomination_id'];
//                $collection[$id][$item['lang_code'] . '_job_image']     = $this->image($item['job_id']);
//                $collection[$id][$item['lang_code'] . '_job_url']       = GLOBAL_URL . $prefix . $item['job_url'];
//
//                $collection[$id][$item['lang_code'] . '_job_nomination']            = $section['name'];
//                $collection[$id][$item['lang_code'] . '_job_nomination_status']     = $section['status'] == 'V';
//                $collection[$id][$item['lang_code'] . '_job_nomination_order_by']   = $section['sortOrder'];
//                $collection[$id][$item['lang_code'] . '_job_name']          = $item['title'];
//                $collection[$id][$item['lang_code'] . '_job_link']          = $item['link'];
//                $collection[$id][$item['lang_code'] . '_job_description']   = $item['content'];
//                $collection[$id][$item['lang_code'] . '_job_added']         = $item['addedOn'];
//            }
//
//        })->all();
//
//        $collection = array_values($collection);
//        usort($collection, array($this, 'sectionSortByOrder'));
//
//        $this->response = array('status' =>200, 'message' => "Request completed successfully", 'error' => null, 'data' => $collection);
////        return array_values($collection);
//    }

    private function getNominationName($lang_code, $sectionId)
    {
        $prefix = ($lang_code == 'uz') ? 'ls_' . $lang_code . '_' : 'ls_';

        $nomination = DB::init()->connect()->query("SELECT `name`, `status`, `sortOrder` FROM " .$prefix ."sections WHERE sectionId=".$sectionId)
//            ->cache(60)
            ->fetch('array');
        if (!empty($nomination)) {
            return $nomination;
        }
        return null;
    }

    private function image($jobId): ?string
    {
        if ($file = connect($this->table_image)->usingJoin('files', 'fileId')->where($this->primaryKey, $jobId)->cache(60)->get('array')) {
            return SITE_URL . ImageSizes::init()->get(null, $file)['original'];
        }
        return null;
    }

    private function sectionSortByOrder(&$a, &$b): int
    {
        if ($a == $b) {
            return 0;
        }

        return ($a['ru_job_nomination_order_by'] < $b['ru_job_nomination_order_by']) ? -1 : 1;
    }


}
