<?php
/******************************************************************************/
//                                                                            //
//                             Smarty plugin                                  //
//                            @package Smarty                                 //
//							 @subpackage plugins                              //
//                        http://life-style.uz/                               //
//                   produced by Life Style, life-style.uz                    //
//                                                                            //
/******************************************************************************/


use Endroid\QrCode\Builder\Builder;
use Endroid\QrCode\Encoding\Encoding;
use Endroid\QrCode\ErrorCorrectionLevel\ErrorCorrectionLevelHigh;
use Endroid\QrCode\Label\Alignment\LabelAlignmentCenter;
use Endroid\QrCode\Label\Font\NotoSans;
use Endroid\QrCode\RoundBlockSizeMode\RoundBlockSizeModeMargin;
use Endroid\QrCode\Writer\PngWriter;

function smarty_function_fetch_user($params, &$smarty){

//    include  GLOBAL_ROOT. '/includes/Classes/phpqrcode/qrlib.php';

	$assign    = fetch_getParam('assign', $params, 'customer');
	$links    = fetch_getParam('link', $params);
    $QRcode    = fetch_getParam('QRcode', $params);
	$fields    = fetch_getParam('fields', $params, '*');
	$userId    = (int) fetch_getParam('userId', $params, 0);

	if(empty($assign)){
		$smarty->_trigger_fatal_error('fetch_comments: "assign" must not be empty');
		return;
	}

    $customer = array();
    $dataUri = '';
	/* conditions */
    if(!empty($userId)) {
        $customer = connect('customers')->select($fields)->where('userId', $userId)->get('array');

        if (!empty($customer['userId'])) {
            $link = GLOBAL_URL . "/admin/customer?action=state&id=" . $customer['userId'];
            $result = Builder::create()->writer(new PngWriter())->writerOptions([])
                ->data($link)->encoding(new Encoding('UTF-8'))
                ->errorCorrectionLevel(new ErrorCorrectionLevelHigh())
                ->size(240)
                ->margin(10)
                ->roundBlockSizeMode(new RoundBlockSizeModeMargin())
                ->validateResult(false)
                ->build();

            $result->saveToFile( GLOBAL_ROOT . '/customers/qrcode_' . $customer['userId'] . '.png');
            $dataUri = $result->getDataUri();


        }
    }
//    print_r($customer);

	$smarty->assign($assign, $customer);
	$smarty->assign($links, $link);
    $smarty->assign($QRcode, $dataUri);

	return null;
}

?>