{include file="header.tpl" title=$section.name keywords=$section.keywords description=$section.description}
{if isset($siteUser.userId)}
<main class="main">

	<div class="flex:col">
		<div class="intro">
			<div class="intro__bg"><img src="{$ASSETS_URL}/images/bg/3.jpg" alt="{$section.name}"></div>
			<div class="flex:col-max">
				<div class="intro__info">
					<div class="text-tmp title-44 title-tt-up txt-18 all-center marg-all-10 color-white">
						<h1>{$section.name}</h1>
					</div>
				</div>
			</div>
		</div>
	</div>

	<section class="flex:col pad-tb-100">
		<div class="flex:col-max">

			<div class="grid:fr-1 g-gap-60">

				<div class="text-tmp title-44 txt-18 txt-danger title-tt-up all-center marg-all-10">
					{$section.content nofilter}
				</div>

				<form class="form validation_js max-w-600 x-center" action="{$GLOBAL_URL}/ajax-brand" method="post" id="brand">

					<div class="grid:fr-1 g-gap-80">

						<div class="grid:fr-1 g-gap-30">

							<div class="file-large file_js">
								<label class="file-large__label">
									<input class="file-large__input" type="file" name="file" data-type="image" data-error-type="Только PDF файлы" data-size="Файл не должен превышать 10мб">

									<p>Загрузить: Логотип бренда (500х500 пиксель) jpg/png</p>
									<div class="file-large__icon">
										<svg xmlns="http://www.w3.org/2000/svg" height="20" viewBox="0 -960 960 960" width="20">
											<path d="M249.764-200.5q-20.901 0-35.083-14.531-14.181-14.531-14.181-34.733v-460.472q0-20.202 14.181-34.733 14.182-14.531 35.083-14.531h460.472q20.902 0 35.083 14.531 14.181 14.531 14.181 34.733v460.472q0 20.202-14.181 34.733-14.181 14.531-35.083 14.531H249.764ZM250-218h460q12 0 22-10t10-22v-460q0-12-10-22t-22-10H250q-12 0-22 10t-10 22v460q0 12 10 22t22 10Zm96-97.5h276.5L529-440l-87 106.5-45-48-51 66ZM218-218v-524 524Z" />
										</svg>
									</div>
								</label>
							</div>

							<div class="input">
								<label class="input__label" for>Название Компании / Бренд:</label>
								<input class="not-empty" type="text" name="brand[brand]" value="{$siteUser.company}" data-empty="Обязательно для заполнения">
							</div>

							<div class="input">
								<label class="input__label" for>Контактное лицо (Имя и фамилия)</label>
								<input class="not-empty" type="text" name="brand[fullName]" value="{$siteUser.fullName}" data-empty="Обязательно для заполнения">
							</div>

							<div class="input">
								<label class="input__label" for>ИНН компании</label>
								<input class="not-empty" type="text" name="brand[inn]" value="{$siteUser.inn}" data-empty="Обязательно для заполнения">
							</div>

							{foreach from=$LANGUAGES item=language key=prefix name=languages}
							<div class="input">
								<label class="input__label" for>Достижения за 2023 год <span>на {$prefix|upper}</span></label>
								<textarea name="desc[{$prefix}][content]" class="input__textarea input__field"  data-empty="Обязательно для заполнения"></textarea>
							</div>
							{/foreach}

							<div class="input">
								<label class="input__label" for>Номер телефона:</label>
								<input class="phone_js not-empty" type="tel" name="brand[phone]" value="{$siteUser.phone}" data-empty="Обязательно для заполнения">
							</div>

							<div class="input">
								<label class="input__label" for>E-mail:</label>
								<input class="email_js not-valid" type="email" name="brand[email]" value="{$siteUser.email}" data-empty="Обязательно для заполнения" data-empty-email="Введите E-mail корректно">
							</div>

							<div class="input">
								<label class="input__label" for>Номинация:</label>
								<div class="select-custom select-custom_js">
									<select name="brand[nomination]" id>
										{fetch_sections assign=nominations from=3 status="V" getContent=true}{if !empty($nominations)}
											{foreach item=nomination from=$nominations name=nominations}
												<option value="{$nomination.sectionId}">{$nomination.name}</option>
											{/foreach}{/if}
									</select>
								</div>
							</div>

							<div class="text-tmp all-center accent-5">
								<p>Выберете, где пройдет голосование за ваш бренд (можно выбрать один или оба варианта)</p>
							</div>

							<div class="form-fr-2">

								<div class="checkbox">
									<label class="checkbox__label">
										<input class="checkbox__input not-valid" type="checkbox" name="brand[consumer]">

										<span class="checkbox__content">
											<svg width="17" height="13" viewBox="0 0 17 13" fill="none" xmlns="http://www.w3.org/2000/svg">
												<path d="M15.0806 0L5.75806 9.20833L1.91935 5.41667L0 7.3125L5.75806 13L17 1.89583L15.0806 0Z" fill="white" />
											</svg>
										</span>

										<p>Голосование потребителей</p>
									</label>
								</div>

								<div class="checkbox">
									<label class="checkbox__label">
										<input class="checkbox__input not-valid" type="checkbox" name="brand[expert]">
										<span class="checkbox__content">
											<svg width="17" height="13" viewBox="0 0 17 13" fill="none" xmlns="http://www.w3.org/2000/svg">
												<path d="M15.0806 0L5.75806 9.20833L1.91935 5.41667L0 7.3125L5.75806 13L17 1.89583L15.0806 0Z" fill="white" />
											</svg>
										</span>
										<p>Голосование экспертов</p>
									</label>
								</div>

							</div>
						</div>

						<div class="grid:fr-1 g-gap-30">
							{foreach from=$LANGUAGES item=language key=prefix name=languages}
							<div class="input">
								<label class="input__label" for>Укажите ссылку на Youtube (Видеоролик / Видео презентация бренда) либо загрузите презентацию в виде PDF <span>на {$prefix|upper}</span></label>
								<input class="not-valid" type="text" name="desc[{$prefix}][youtube]" data-empty="Обязательно для заполнения">
							</div>
							{/foreach}

							{foreach from=$LANGUAGES item=language key=prefix name=languages}
							<div class="file-large data-show file_js">
								<label class="file-large__label">
									<input class="file-large__input not-valid" type="file" name="pdf[{$prefix}]" data-type="pdf" data-error-type="Только PDF файлы" data-size="Файл не должен превышать 10мб">

									<p>Загрузить: PDF презентация, не более 10 слайдов <span>на {$prefix|upper}</span></p>
									<div class="file-large__icon">
										<svg xmlns="http://www.w3.org/2000/svg" height="20" viewBox="0 -960 960 960" width="20">
											<path xmlns="http://www.w3.org/2000/svg" d="M341.5-460.5H377V-532h36q14.762 0 24.881-10.156T448-567.5v-36q0-14.763-10.013-24.881Q427.975-638.5 413-638.5h-71.5v178Zm35.5-107v-36h36v36h-36Zm96.5 107h67.351q15.262 0 25.205-10.05Q576-480.6 576-496v-107.438q0-14.825-10.012-24.943Q555.975-638.5 541-638.5h-67.5v178ZM509-496v-107.5h32V-496h-32Zm103.5 35.5h35V-532h69v-35.5h-69v-36h69v-35h-104v178ZM315.5-292q-21.138 0-35.319-14.181Q266-320.362 266-341.5v-416q0-21.138 14.181-35.319Q294.362-807 315.5-807h416q21.138 0 35.319 14.181Q781-778.638 781-757.5v416q0 21.138-14.181 35.319Q752.638-292 731.5-292h-416Zm0-17.5h416q12 0 22-10t10-22v-416q0-12-10-22t-22-10h-416q-12 0-22 10t-10 22v416q0 12 10 22t22 10Zm-87 104.5q-21.137 0-35.319-14.181Q179-233.363 179-254.5V-688h17.5v433.5q0 12 10 22t22 10H662v17.5H228.5Zm55-584.5v480-480Z" />
										</svg>
									</div>
								</label>
							</div>
							{/foreach}

							<label class="checkbox__label x-center">
								<input class="checkbox__input" type="checkbox">

								<span class="checkbox__content">
									<svg width="17" height="13" viewBox="0 0 17 13" fill="none" xmlns="http://www.w3.org/2000/svg">
										<path d="M15.0806 0L5.75806 9.20833L1.91935 5.41667L0 7.3125L5.75806 13L17 1.89583L15.0806 0Z" fill="white" />
									</svg>
								</span>
								<p>С Регламентом ознакомлен(а) и согласен(а)</p>
							</label>

							<button class="btn accent large x-center" type="submit">Отправить <span>{include file="icon/svg.tpl" svgId="next_icon" fill="none"}</span></button>
						</div>

					</div>

				</form>


			</div>

		</div>
	</section>

</main>
{else}
	<script>
		window.location = "{$SITE_URL}";
	</script>
{/if}
{include file="footer.tpl"}